#!/bin/bash

source /home/mapetersen/Documents/GromacsMPI/gromacs-2022.5/bin/GMXRC

# set number of simulations to run
NUM_SIMULATIONS=2

# set the command to run for each simulation on gpu
RUN_COMMAND="gmx_mpi mdrun -s ../../md.tpr -deffnm md -nsteps 100000 -ntomp 1 -nb gpu -bonded gpu -update gpu"

# create output directory
mkdir -p output

for ((i=1; i<=$NUM_SIMULATIONS; i++))
do
    # create simulation subdirectory
    SIMULATION_DIR=output/simulation_$i
    mkdir -p $SIMULATION_DIR

    # run simulation and save output to simulation subdirectory
    cd $SIMULATION_DIR
    $RUN_COMMAND >& log.txt &

    # return to parent directory
    cd ..
    cd ..
done

# wait for all simulations to finish
wait


